<?php

/*
class AllegroWeb

Subversion: $Id: webapi.php 17 2007-07-27 18:01:52Z tom $
*/

/***************************************************************************
 * Allegro Widget (plugin to Wordpress)                                    *
 * Copyright (C) 2007  Tomasz Gloc (tpython@tpython.com)                   *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation, either version 3 of the License, or       *
 * (at your option) any later version.                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.   *
 **************************************************************************/

if(class_exists('SoapClient')) {
	require_once('mysoapclient5.php');
} else /* !class_exists('SoapClient') */ {
	require_once('mysoapclient4.php');
}

global $allegro_sites;
$allegro_sites = array(
	'Allegro.pl'   => array(
		'country' => 1,
		'url' => 'http://www.allegro.pl',
		'wsdl' => 'https://webapi.allegro.pl/uploader.php?wsdl',
		'site-code-page' => 'iso8859-2',
		'currency' => ' zł'
	),
	'Aukro.cz'     => array(
		'country' => 56,
		'url' => 'http://www.aukro.cz',
		'wsdl' => 'https://webapi.aukro.cz/uploader.php?wsdl',
		'site-code-page' => 'iso8859-2',
		'currency' => ''
	),
	'Aukro.ru'     => array(
		'country' => 168,
		'url' => 'http://www.aukro.ru',
		'wsdl' => 'https://webapi.aukro.ru/uploader.php?wsdl',
		'site-code-page' => 'iso8859-1',
		'currency' => ''
	),
	'TestWebAPI.pl' => array(
		'country' => 228,
		'url' => 'http://www.testwebapi.pl',
		'wsdl' => 'https://webapi.allegro.pl/uploader.php?wsdl',
		'site-code-page' => 'iso8859-1',
		'currency' => ' zł'
	)
);

function object2array($object) {
  if(is_object($object)) {
		$array = array();
    foreach($object as $key => $value) {
      $array[$key] = $value;
    }
		return $array;
  }
	return $object;
}

class AllegroWeb {
	function __construct($language, $key, $login, $userID, $selectedSite) {
		global $allegro_sites;
		
		$this->lang = $language;
		$this->key = $key;
		$this->login = $login;
		$this->userID = $userID;
		$this->selectedSite = $selectedSite;
		
		$this->site = $allegro_sites[$selectedSite];
	}
	
	function AllegroWeb($language, $key, $login, $userID, $selectedSite) {
		$this->__construct($language, $key, $login, $userID, $selectedSite);
	}
	
	function createSoap() {
		$this->soap = new MySoapClient($this->site['wsdl']);
	}

	function getUserItems($maxLimit = 0) {
		if(!$this->userItems) {
			if(!$this->soap) {
				$this->createSoap();
				if($this->soap->getError()) return null;
			}
			$offset = 0;
			$limit = 100;

			if($maxLimit > 0 && $limit > $maxLimit) {
				$limit = $maxLimit;
			}

			$data = array(
				'user-id' => $this->getUserID(),
				'webapi-key' => $this->key,
				'country-id' => $this->lang,
				'offset' => $offset,
				'limit' => $limit
			);
			$ret = $this->soap->call('doGetUserItems', $data);
			$cnt = $ret['user-item-count']; //łączna ilość aukcji
			$items = $ret['user-item-list']; //aukcje

			if($maxLimit > 0) {
				$remCnt = min($cnt, $maxLimit) - $limit; //ilość do pobrania minus pobrana
			} else {
				$remCnt = $cnt - $limit;
			}

			while($remCnt > 0) {
				++$offset;
				$data['offset'] = $offset;
				$ret = $this->soap->call('doGetUserItems', $data);
				$items = array_merge($items, $ret['user-item-list']);
				$remCnt -= $data['limit'];
			}

			$this->userItems = array('user-item-count' => $cnt, 'user-item-list' => $items);
		}
		return $this->userItems;
	}
	
	function getUserID() {
		if(!$this->userID) {
			if(!$this->soap) {
				$this->createSoap();
				if($this->soap->getError()) return null;
			}
			$data = array(
				'country-id' => $this->lang,
				'user-login' => $this->login,
				'user-email ' => $this->email,
				'webapi-key' => $this->key
			);
			$this->userID = $this->soap->call('doGetUserID', $data);
		}
		return $this->userID;
	}
	
	function getSiteURL() {
		return $this->site['url'];
	}
	
	function getSiteCurrency() {
		return $this->site['currency'];
	}
	
	function getError() {
		if($this->soap) {
			return $this->soap->getError();
		}
		return null;
	}
	
	function load($data) {
		if(is_array($data)) {
			$this->userItems = $data['userItems'];
		}
	}
	
	function save() {
		return array(
			'userItems' => $this->userItems,
			'time'      => time()
		);
	}
	
	var $soap;
	var $lang;
	var $key;
	var $login;
	var $userID;
	var $email;
	var $userItems;
	var $selectedSite;
	var $site;
}

?>
