<?php

/*
class MySoapClient (for PHP5)

Subversion: $Id: mysoapclient5.php 11 2007-07-22 11:51:24Z tom $
*/

/***************************************************************************
 * MySoapClient                                                            *
 * Copyright (C) 2007  Tomasz Gloc (tpython@tpython.com)                   *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation, either version 3 of the License, or       *
 * (at your option) any later version.                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.   *
 **************************************************************************/

class MySoapClient {
	function __construct($url) {
		try {
			ini_set('default_socket_timeout', 5);
			@$this->soap = new SoapClient($url, array('connection_timeout' => 10));
			ini_restore('default_socket_timeout');
			$this->soap->soap_defencoding = 'UTF-8';
			$this->soap->decode_utf8 = false;
		} catch(Exception $e) {
			$this->error = __('Error: Cannot connect to server.');
		}
	}
	
	function MySoapClient($url) {
		$this->__construct($url);
	}
	
	function call($command, $data) {
		try {
			return $this->soap->__soapCall($command, $data);
		} catch(SoapFault $e) {
			$this->error = $e->faultstring;
			return null;
		}
	}
	
	function getError() {
		return $this->error;
	}
	
	var $soap;
	var $error;
}

?>