<?php

/*
class MySoapClient (for PHP4)

Subversion: $Id: mysoapclient4.php 11 2007-07-22 11:51:24Z tom $
*/

/***************************************************************************
 * MySoapClient                                                            *
 * Copyright (C) 2007  Tomasz Gloc (tpython@tpython.com)                   *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation, either version 3 of the License, or       *
 * (at your option) any later version.                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.   *
 **************************************************************************/

require_once('nusoap.php');

class MySoapClient {
	function __construct($url) {
		$this->soap = new soapclient($url, true, false, false, false, false, 5, 5);
		$this->soap->soap_defencoding = 'UTF-8';
		$this->soap->decode_utf8 = false;
		if($this->soap->getError()) {
			$this->error = __('Error: Cannot connect to server.');
		}
	}
	
	function MySoapClient($url) {
		$this->__construct($url);
	}
	
	function call($command, $data) {
		$ret = $this->soap->call($command, $data);
		if($this->soap->fault) {
			$this->error = $this->soap->getError();
			return null;
		}
		return $ret;
	}
	
	function getError() {
		return $this->error;
	}
	
	var $soap;
	var $error;
}

?>