<?php
/*
Plugin Name: Allegro Widget
Plugin URI: http://www.tpython.com/allegro-widget/
Description: Allegro Widget
Version: 0.1.2
Author: tPython
Author URI: http://www.tpython.com/

Subversion: $Id: allegro-widget.php 17 2007-07-27 18:01:52Z tom $
*/

/***************************************************************************
 * Allegro Widget (plugin to Wordpress)                                    *
 * Copyright (C) 2007  Tomasz Gloc (tpython@tpython.com)                   *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation, either version 3 of the License, or       *
 * (at your option) any later version.                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.   *
 **************************************************************************/
 
load_plugin_textdomain('allegro-widget', 'wp-content/plugins/allegro-widget/i18n');

function widget_allegro_init() {
	if(!function_exists('register_sidebar_widget') || !function_exists('register_widget_control')) return;

	require_once('webapi.php');
	
	function widget_allegro_show($args) {
		extract($args);
		
		$options = get_option('allegro_widget');
		$title = $options['title'];
		$login = $options['login'];
		$key = $options['key'];
		$lang = $options['lang'];
		$userID = $options['userID'];
		$siteName = $options['site'];
		$cachetime = intval($options['cache']);
		$enable_cache = $cachetime > 0;
		
		$allegro = new AllegroWeb($lang, $key, $login, $userID, $siteName);
		if($allegro->getError()) {
			echo $allegro->getError();
			update_option('allegro_widget_cache', null);
			return;
		};
		
		if($enable_cache) {
			$cache = get_option('allegro_widget_cache');
			if($cache && (time() - $cache['time'] <= $cachetime)) {
				$allegro->load($cache);
			}
		}
		
		$ret = $allegro->getUserItems(0);
		$items = $ret['user-item-list'];
		
		$url = $allegro->getSiteUrl();
		$currency = $allegro->getSiteCurrency();
		if($allegro->getError()) {
			echo $allegro->getError();
			return;
		};

		if($enable_cache && (!$cache || (time() - $cache['time'] > $cachetime))) {
			$cache = $allegro->save();
			update_option('allegro_widget_cache', $cache);
		}
		
		echo $before_widget . $before_title . $title . $after_title;
	?>
	<ul>
	<?php foreach($items as $item) {
		$item = object2array($item);
		$leftTime = $item['it-time-left'];
		$leftTimeDesc = '<1 minute';
		if($leftTime > 60 && $leftTime <= 3600) $leftTimeDesc = (int)($leftTime / 60) . __(' minutes', 'allegro-widget');
		else if($leftTime > 3600 && $leftTime <= 60*60*24) $leftTimeDesc = (int)($leftTime / 3600) . __(' hours', 'allegro-widget');
		else if($leftTime > 86400) $leftTimeDesc = (int)($leftTime / 86400) . __(' days', 'allegro-widget');
	?>
		<li>
			<a href="<?php echo $url; ?>/show_item.php?item=<?php echo $item['it-id']; ?>" onmouseover="allegro_widget_showDesc(<?php echo $item['it-id']; ?>)" onmouseout="allegro_widget_hideDesc(<?php echo $item['it-id']; ?>)"><?php echo $item['it-name']; ?></a>
			<br/>
			<div id="allegro_widget_<?php echo $item['it-id']; ?>" class="allegro_description"><table>
				<?php if($item['it-price']) { ?>
				<tr>
					<td style="width:100px"><?php _e('Price:', 'allegro-widget'); ?></td>
					<td style="width:100px; text-align:right;"><?php echo $item['it-price'] . $currency; ?></td>
				</tr>
				<?php } ?>
				<?php if($item['it-is-buy-now']) { ?>
				<tr>
					<td style="width:100px"><?php _e('Buy Now price:', 'allegro-widget'); ?></td>
					<td style="width:80px; text-align:right;"><?php echo $item['it-buy-now-price'] . $currency; ?></td>
				</tr>
				<?php } ?>
				<tr>
					<td style="width:100px"><?php _e('Time left:', 'allegro-widget'); ?></td>
					<td style="width:100px; text-align:right;"><?php echo  $leftTimeDesc; ?></td>
				</tr>
			</table></div>
		</li>
		<script type="text/javascript">allegro_widget_hideDesc('<?php echo $item['it-id']; ?>')</script>
	<?php } ?>
	</ul>
	<?php
		echo $after_widget; 
	}

	function widget_allegro_control() {
		global $allegro_sites;
		
		$options = get_option('allegro_widget');

		if(isset($_POST['allegro-submit'])) {
			$options = array();
			$options['title'] = strip_tags(stripslashes($_POST['allegro-title']));
			$options['login'] = strip_tags(stripslashes($_POST['allegro-login']));
			$options['key'] = strip_tags(stripslashes($_POST['allegro-key']));
			$options['site'] = strip_tags(stripslashes($_POST['allegro-site']));
			$options['cache'] = strip_tags(stripslashes($_POST['allegro-cachetime']));
			
			$options['lang'] = $allegro_sites[$options['site']]['country'];

			$allegro = new AllegroWeb($options['lang'], $options['key'], $options['login'], null, $options['site']);
			$options['userID'] = $allegro->getUserID();
			if($allegro->getError()) {
				echo '<script>alert("Allegro Widget error:\n' . $allegro->getError() . '");</script>';
			}
			
			update_option('allegro_widget', $options);
			update_option('allegro_widget_cache', null);
		}
		
		if(!is_array($options)) {
			//set default
			$options['title'] = 'Allegro';
			$options['login'] = __('Put login name here', 'allegro-widget');
			$options['key'] = __('Put WebAPI key here', 'allegro-widget');
			$options['site'] = 'Allegro.pl';
			$options['cache'] = '600';
		}
		
		$title = htmlspecialchars($options['title'], ENT_QUOTES);
		$login = htmlspecialchars($options['login'], ENT_QUOTES);
		$key = htmlspecialchars($options['key'], ENT_QUOTES);
		$site = htmlspecialchars($options['site'], ENT_QUOTES);
		$cachetime = htmlspecialchars($options['cache'], ENT_QUOTES);
	?>
	<table>
		<tr>
			<td><label for="allegro-title"><?php _e('Title:', 'allegro-widget'); ?></label></td>
			<td><input style="width: 200px;" type="text" id="allegro-title" name="allegro-title" value="<?php echo $title; ?>" /></td>
			<td><span onmouseover="this.nextSibling.style.display='block'" onmouseout="this.nextSibling.style.display='none'">?</span><div style="display:none" class="allegro_description"><?php _e('Widget headname.', 'allegro-widget'); ?></div></td>
		</tr>
		<tr>
			<td><label for="allegro-site"><?php _e('Site:', 'allegro-widget'); ?></label></td>
			<td><select id="allegro-site" name="allegro-site">
			<?php foreach($allegro_sites as $site_name => $site_data) { ?>
				<option<?php if($site == $site_name) echo ' selected="selected"'; ?>><?php echo $site_name ?></option>
			<?php } ?>
			</select></td>
			<td><span onmouseover="this.nextSibling.style.display='block'" onmouseout="this.nextSibling.style.display='none'">?</span><div style="display:none" class="allegro_description"><?php _e('Select your site.<br/>TestWebApi.pl is useful for testing.', 'allegro-widget'); ?></div></td>
		</tr>
		<tr>
			<td><label for="allegro-login"><?php _e('Login:', 'allegro-widget'); ?></label></td>
			<td><input style="width: 200px;" type="text" id="allegro-login" name="allegro-login" value="<?php echo $login; ?>" /></td>
			<td><span onmouseover="this.nextSibling.style.display='block'" onmouseout="this.nextSibling.style.display='none'">?</span><div style="display:none" class="allegro_description"><?php _e('Write your login name from auction\'s site.', 'allegro-widget'); ?></div></td>
		</tr>
		<tr>
			<td><label for="allegro-key"><?php _e('WebAPI Key:', 'allegro-widget'); ?></label></td>
			<td><input style="width: 200px;" type="text" id="allegro-key" name="allegro-key" value="<?php echo $key; ?>" /></td>
			<td><span onmouseover="this.nextSibling.style.display='block'">?</span><div title="<?php _e('Click to hide.', 'allegro-widget'); ?>" style="display:none" class="allegro_description" onclick="this.style.display='none'"><?php _e('Write your WebAPI key.<br/>You can get it from auction\'s site.', 'allegro-widget'); ?></div></td>
		</tr>
		<tr>
			<td><label for="allegro-key"><?php _e('Cache time:', 'allegro-widget'); ?></label></td>
			<td><input style="width: 200px;" type="text" id="allegro-cachetime" name="allegro-cachetime" value="<?php echo $cachetime; ?>" /></td>
			<td><span onmouseover="this.nextSibling.style.display='block'">?</span><div title="<?php _e('Click to hide.', 'allegro-widget'); ?>" style="display:none" class="allegro_description" onclick="this.style.display='none'"><?php _e('Cache time in seconds.', 'allegro-widget'); ?></div></td>
		</tr>
		<input type="hidden" name="allegro-submit" id="allegro-submit" value="1" />
	</table>
	<br/>
	<div><?php _e('You have to accept auction user agreement, WebAPI agreement and this software license before use Allegro Widget.', 'allegro-widget'); ?></div>
	<br/>
	<div style="text-align:center">
		<?php _e('Allegro Widget is free software.<br/>Please make dotation:', 'allegro-widget'); ?>
		<br/>
		<a href="<?php echo get_option('siteurl') . '/wp-content/plugins/allegro-widget/dotations.html';?>"><img src="https://www.paypal.com/pl_PL/i/btn/x-click-but04.gif" border="0" alt="Dotacja przez PayPal"></a>
		<br/>
		<?php _e('Thanks', 'allegro-widget'); ?>
	</div>
	<?php
	}

	register_sidebar_widget('Allegro Widget', 'widget_allegro_show');
	register_widget_control('Allegro Widget', 'widget_allegro_control', 340, 340);
}

function widget_allegro_head() {
?>
<script type="text/javascript">
function allegro_widget_showDesc(id) {
	document.getElementById('allegro_widget_' + id).style.display = 'block';
};
function allegro_widget_hideDesc(id) {
	document.getElementById('allegro_widget_' + id).style.display = 'none';
};
</script>
<style type="text/css">
.allegro_description {
	background-color: #DDDDDD;
	border: 1px solid black;
	color: black;
	padding: 4px;
	position: absolute;
	width: 180px;
}
</style>
<?php
}

add_action('plugins_loaded', 'widget_allegro_init');
add_action('wp_head', 'widget_allegro_head');
add_action('admin_head', 'widget_allegro_head');

?>